# Customize
# Intended name of binary package. 
# For now, the name of the package will be `qmail' so 
# rpm can upgrade older qmail rpms properly; the `Obsoletes' tag is 
# just not doing what we need.  The name below refers to the prefix name for 
# everything else in the binary package but the name. The actual name of the 
# package is determined in the `VNAME=qmail' assignment below.
%define vname var-qmail_PATCHEXT
%define vsrcname var-qmail
# qmail's home directory
%define qmailhome /var/qmail
# If you redistribute the created binary qmail package, 
# you must change this
%define vpackager mw@csi.hu
# If you change anything in this package, change this
Packager: mw@csi.hu
Release: 112_STRING_PATCHEXT
# end customize: change below at your own risk
%define destdir %buildroot
%define distdir %vname-%version
%define vdestdir /tmp/%vname-root
%define vqmailhome %vdestdir%qmailhome
#PATCH_1#%define verhversion 0.07
#PATCH_10#%define syncdir_version 1.0
# Change below, at your own (high) risk
Buildroot: /tmp/%name-root
License: Check with djb@cr.yp.to
ExclusiveOS: Linux
Group: Utilities/System
Name: var-qmail-create
#PATCH_0## rbl, to use MAPS RBL
#PATCH_0#Patch: qmail-%version.rbl.patch
#PATCH_3## dns, to handle big DNS records (S. Schwartz's)
#PATCH_3#Patch3: qmail-%version.dns.patch
#PATCH_4## big-todo, for high volume servers
#PATCH_4#Patch4:qmail-%version.big-todo.patch
#PATCH_5## bigrem, to up the limit on concurrent remote connections (F. Lindberg)
#PATCH_5#Patch5:qmail-%version.bigrem.patch
#PATCH_6## anti-spam, it modifies qmail-smtpd 
#PATCH_6#Patch6:qmail-%version.anti-spam.patch
#PATCH_7## tarpitting, to implement---tarpitting
#PATCH_7#Patch7:qmail-%version.tarpit.patch
#PATCH_8## queuevar, to implement the QMAILQUEUE variable
#PATCH_8#Patch8:qmail-%version.queuevar.patch
#PATCH_9## ext todo, to cure silly qmail syndrome
#PATCH_9#Patch9:qmail-%version.ext_todo.patch
#PATCH_10## syncdir, gives qmail bsd fsync semantics on a Linux filesystem 
#PATCH_10#Patch10:qmail-%version.syncdir.patch
#PATCH_11## qmtpc, attempt qmtp first if the MX priority indicates so. 
#PATCH_11#Patch11:qmail-%version.qmtpc.patch
#PATCH_12## condredirect, define exit with 100 
#PATCH_12#Patch12:qmail-%version.condredirect.patch
#PATCH_13## pop3d_stat, fixes STAT command
#PATCH_13#Patch13:qmail-%version.pop3d_stat.patch
#PATCH_14## errno, fixes errno declaration 
#PATCH_14#Patch14:qmail-%version.errno.patch
#PATCH_15## qmail_local, fixes and_or typo in qmail-local.c 
#PATCH_15#Patch15:qmail-%version.qmail_local.patch
Requires: rpm >= 3
Source0: ftp://cr.yp.to/software/qmail-%version.tar.gz
#PATCH_1## verh, for personalized headers in ezmlm lists
#PATCH_1#Source11: http://www.augensalat.de/software/qmail-verh-%{verhversion}.tar.gz
#PATCH_2## qmqpc, to allow command line spec of qmqp servers (F. Lindberg)
#PATCH_2#Source12:ftp://ftp.id.wustl.edu/outgoing/lindberg/qmail-qmqpc.tar.gz
#PATCH_10#Source13:syncdir-%syncdir_version.tar.gz
Source1: %name-%vsrcname.spec
Source2: %name-add-account
Source3: %name-add-group
Source4: %name-Makefile
Source5: %name-README_rpm
Source6: %name.mem_replace.sh
Summary: Creates binary package for qmail
URL: http://www.qmail.org/
Version: 1.03

%description
This package creates a binary package for qmail.

%prep
%setup -q -n qmail-%version

#PATCH_0#%patch0 -p1

#PATCH_1#%setup -q -n qmail-%version -T -D -a 11
#PATCH_1#patch < qmail-verh-%{verhversion}/qmail-local.diff
#PATCH_1#patch < qmail-verh-%{verhversion}/qmail-remote.diff

#PATCH_2#%setup -q -n qmail-%version -T -D -a 12
#PATCH_2#patch      < qmqp/qmail-qmqpc.diff

#PATCH_3#%patch3 -p0
#PATCH_4#%patch4 -p1
#PATCH_5#%patch5 -p1
#PATCH_6#%patch6 -p1
#PATCH_7#%patch7 -p1
#PATCH_8#%patch8 -p1
#PATCH_9#%patch9 -p1

#PATCH_10#%patch10 -p1
#PATCH_10#%setup -q -n qmail-%version -T -D -a 13
#PATCH_10#( cd syncdir-%syncdir_version
#PATCH_10#make libsyncdir.a
#PATCH_10#cp -p libsyncdir.a ..
#PATCH_10#)

#PATCH_11#%patch11 -p1
#PATCH_12#%patch12 -p1
#PATCH_13#%patch13 -p1
#PATCH_14#%patch14 -p1
#PATCH_15#%patch15 -p1
%build

# create auto_uids.c so that the qmail users
# do not have to be added
cat > auto_uids.c <<EOF
int auto_uida = 1;
int auto_uidd = 1;
int auto_uidl = 1;
int auto_uido = 1;
int auto_uidp = 1;
int auto_uidq = 1;
int auto_uidr = 1;
int auto_uids = 1;
int auto_gidq = 1;
int auto_gidn = 1;
EOF

# Fix Makefile so that auto_uids.c 
# does not get created
sed '/auto_uids.c: /,/^$/ s/^/# /' Makefile > Makefile.tmp
mv Makefile.tmp Makefile

# make does not notice short time intervals
sleep 1
# Fix hier.c so that nothing gets installed
# in man/cat?.
grep -v "man/cat*" hier.c > hier.c.tmp 
mv hier.c.tmp hier.c

echo %qmailhome > conf-qmail
make -o auto_uids.c auto_uids.o
make -o auto_uids.c
make man

# get a list of files to be put in the distribution
grep "c(" hier.c | awk -F, '{ print $3 }'| sed 's/\"//g' > distr_files

mkdir %distdir
cp $(cat distr_files) %distdir

# these are needed for installation
mv config config-fast dnsfq dnsip dnsptr hostname \
idedit instcheck ipmeprint %distdir

# Now find out the byte positions of auto_uid* and auto_gid* in 
# instcheck qmail-lspawn qmail-queue qmail-rspawn qmail-showctl 
# qmail-start.  install will be treated separately.
# We just need to find out the byte position of auto_uida.  

# for make
sleep 1
PROGS="instcheck qmail-lspawn qmail-queue qmail-rspawn qmail-showctl qmail-start"
# change uids
awk -F"=" '/int/ { $2=($2 + 1); print $1"= "$2";" }' auto_uids.c \
    > auto_uids.c.tmp
mv auto_uids.c.tmp auto_uids.c

make 

# find byteposition of auto_uida
for prog in $PROGS; do
    cmp -l $prog %distdir/$prog |
    awk 'NR==1 { print $1 }' > $prog.auto_uida
done

# Now deal with install:
# In the distribution, we  need an install 
# that thinks ~qmail=%vqmailhome
sleep 1
echo %vqmailhome >  conf-qmail
make install
mv install %distdir

sleep 1
# change uids
awk -F"=" '/int/ { $2=($2 + 1); print $1"= "$2";" }' auto_uids.c \
    > auto_uids.c.tmp
mv auto_uids.c.tmp auto_uids.c
make install

# find byteposition of auto_uida
cmp -l install  %distdir/install |
    awk 'NR==1 { print $1 }' > install.auto_uida


# generate arguments for idedit
bytepos() {
    i=1
    byte=$[ $1 - 1 ]
    while [ $i -le 40 ]; do
        echo -n "$byte "
        byte=$[ byte + 1]
    i=$[ i + 1 ]
    done   
}

ALLPROGS="install $PROGS"
for prog in $ALLPROGS; do
    bytepos $(cat $prog.auto_uida) > $prog.idedit_args
done

newname() {
    basename $1|sed 's}%name-}}'  
}
for i  in %SOURCE2 %SOURCE3 %SOURCE4 %SOURCE5; do
    cp $i %distdir/$(newname $i)
done

chmod +x %distdir/add-*

# Fix Makefile and README_rpm for the distr
(
cd %distdir

echo "
VQMAILHOME=%vqmailhome
HOSTNAME=hostname -f
" | %SOURCE6 Makefile > Makefile.tmp
mv Makefile.tmp Makefile

COMPILER="Compiler: $(gcc -v 2> gcc.v; cat gcc.v | tail -1; rm -f gcc.v)"
HARDWARE="Hardware: $(uname -m)"
LIBRARY="Library: $(rpm -q glibc)"
OSVERSION="OSversion: $(uname -sr)"
PACKAGER="Packager: %vpackager"
REDHATRELEASE="RedHat release: $(cat /etc/redhat-release)"
RPMVERSION="rpm version: $(rpm -q rpm)"

#BNOPATCH
echo "
COMPILER=$COMPILER 
HARDWARE=$HARDWARE
LIBRARY=$LIBRARY
OSVERSION=$OSVERSION
PACKAGER=$PACKAGER
QMAILHOME=%qmailhome
REDHATRELEASE=$REDHATRELEASE
RPMVERSION=$RPMVERSION
" | %SOURCE6 README_rpm > README_rpm.tmp
mv README_rpm.tmp README_rpm
#ENOPATCH
#BPATCH
echo "This qmail rpm was created in the following environment:

$COMPILER
$HARDWARE
$LIBRARY
$OSVERSION
$PACKAGER
$REDHATRELEASE
$RPMVERSION

This is a patched version of qmail; you cannot distribute it.
The patches used are

#PATCH_0#0 rbl, to use MAPS RBL
#PATCH_1#1 verh, for personalized headers in ezmlm lists
#PATCH_2#2 qmqpc, to allow command line spec of qmqp servers (F. Lindberg)
#PATCH_3#3 dns, to handle long DNS records (S. Schwartz's)
#PATCH_4#4 big-todo, for high volume servers
#PATCH_5#5 bigrem, to up the limit on concurrent remote connections (F. Lindberg)
#PATCH_6#6 anti-spam it modifies qmail-smtpd
#PATCH_7#7 tarpitting, to implement---tarpitting
#PATCH_8#8 queuevar, to implement the QMAILQUEUE variable
#PATCH_9#9 ext todo, to cure silly qmail syndrome
#PATCH_10#10 syncdir, gives qmail bsd fsync semantics on a Linux filesystem
#PATCH_11#11 qmtpc, attempt qmtp first if the MX priority indicates so.
#PATCH_12#12 condredirect, define exit with 100 (B. Guenter)
#PATCH_13#13 pop3d_stat, fixes STAT command
#PATCH_14#14 errno, fixes errno declaration
#PATCH_15#15 qmail_local, fixes and_or typo in qmail-local.c

Where I did not indicate the author, the patch is from www.qmail.org,
and that is where you should go to read about what the patches do.
" > README_rpm
#EPATCH
) 

# Fix %vname.spec
echo '
DISTDIR=%distdir
QMAILHOME=%qmailhome
VRELEASE=%release
VDESTDIR=%vdestdir
VERSION=%version
VNAME=qmail
VPACKAGER=%vpackager
VQMAILHOME=%vqmailhome
' |  %SOURCE6 %SOURCE1 > %vname.spec

# Enter arguments to idedit in Makefile
for prog in $ALLPROGS; do
    sed "s/$prog XXX/$prog $(cat $prog.idedit_args)/" %distdir/Makefile \
    > %distdir/Makefile.tmp
    mv %distdir/Makefile.tmp %distdir/Makefile 
done

# These will go in the RH doc dir
mkdir %distdir/doc
cp BLURB* CHANGES README SECURITY THANKS THOUGHTS TODO %distdir/doc
cp %distdir/README_rpm %distdir/doc

tar zcvf %distdir.tar.gz %distdir

%install
rm -rf %destdir

# Maybe rpm will be able to expand _sourcedir and _specdir
# on the install system; for now, we can only do this.
# In the post section we'll copy all to the right place.
mkdir -p %destdir{%_sourcedir,%_specdir}
cp %vname.spec %destdir%_specdir
cp %distdir.tar.gz %destdir%_sourcedir

#BPATCH
echo "
This rpm creates a patched version of qmail; you cannot distribute it or 
the resulting %vname package.

The patches used are

#PATCH_0#0 rbl, to use MAPS RBL
#PATCH_1#1 verh, for personalized headers in ezmlm lists
#PATCH_2#2 qmqpc, to allow command line spec of qmqp servers (F. Lindberg)
#PATCH_3#3 dns, to handle long DNS records (S. Schwartz's)
#PATCH_4#4 big-todo, for high volume servers
#PATCH_5#5 bigrem, to up the limit on concurrent remote connections (F. Lindberg)
#PATCH_6#6 anti-spam it modifies qmail-smtpd
#PATCH_7#7 tarpitting, to implement---tarpitting
#PATCH_8#8 queuevar, to implement the QMAILQUEUE variable
#PATCH_9#9 ext todo, to cure silly qmail syndrome
#PATCH_10#10 syncdir, gives qmail bsd fsync semantics on a Linux filesystem
#PATCH_11#11 qmtpc, attempt qmtp first if the MX priority indicates so.
#PATCH_12#12 condredirect, define exit with 100 (B. Guenter)
#PATCH_13#13 pop3d_stat, fixes STAT command
#PATCH_14#14 errno, fixes errno declaration
#PATCH_15#15 qmail_local, fixes and_or typo in qmail-local.c

Where I did not indicate the author, the patch is from www.qmail.org,
and that is where you should go to read about what the patches do. 
" > %name.README
#EPATCH

%clean
rm -rf %destdir

%post
# create a spec file, and then run rpm on the
# install system to find out _specdir and _sourcedir
### next rpm will simplify this a great deal

TMPFILE=$(mktemp -q /tmp/1.spec.XXXXXX)
if [ $? -ne 0 ]; then
    echo "$0: Can't create temp file, exiting..."
    exit 1
fi

cat > $TMPFILE <<EOF
Name: 1
Summary: 1
Version: 1
Release: 1
Group: 1
License: 1

%%%description
1

%%%post

ISPECDIR %%_specdir
ISOURCEDIR %%_sourcedir
EOF

ISPECDIR=$(rpm -q --specfile --scripts $TMPFILE |
    grep ISPECDIR| awk '{ print $2 }')
ISOURCEDIR=$(rpm -q --specfile --scripts $TMPFILE |
    grep ISOURCEDIR| awk '{ print $2 }')

if [ "$ISPECDIR" != "%_specdir" ]; then
    cp %_specdir/%vname.spec $ISPECDIR
fi

if [ "$ISOURCEDIR" != "%_sourcedir" ]; then
    cp %_sourcedir/%distdir.tar.gz $ISOURCEDIR
fi

echo The spec file you want to use is %vname.spec

%files
#BPATCH
%doc %name.README
#EPATCH
%_specdir/*
%_sourcedir/*


%changelog
* Tue Oct 25 2005 Mate Wierdl <mw@csi.hu> - 1.03-112_STRING_PATCHEXT
- Changed Copyright to License, added some sleeps for make

* Thu Jan  9 2003 Mate Wierdl <mw@csi.hu>
- Added errno and qmail_local patches

* Tue Jun 11 2002 Mate Wierdl <mw@csi.hu>
- Added pop3d_stat patch

* Thu Jun  6 2002 Mate Wierdl <mw@csi.hu>
- Added ext-todo, syncdir, qmtpc, condredirect patches

* Thu May  2 2002 Mate Wierdl <mw@csi.hu>
-- Added queuevar patch

* Mon Jul 26 1999 Mate Wierdl <mw@moni.msci.memphis.edu>
-- First version 



