#! /bin/sh

#
# apply all patches:
#
#       var-qmail-create-make-spec.sh all    
#
# give a list of all patches (use the serial numbers)
#
#       var-qmail-create-make-spec.sh list   
#
# specify patches:
#
#       var-qmail-create-make-spec.sh [patch...] 
#
# for example
#
#       var-qmail-create-make-spec.sh 0 3 1
#
# will create a spec file (in the current directory) 
# which will then build qmail using patches 0 3 1.  
# The spec file's name is var-qmail-create_0_1_3.spec, and 
# the applied patches will also appear in the name of the 
# intermediate and final packages.
#
# The command
#
#     var-qmail-create-make-spec.sh
#
# creates the spec file var-qmail-create.spec which will then build
# qmail w/o patches.  This, and only this  can then be redistributed.
# The appropriate READMEs included in the packages will inform you about
# this.

PNAME=var-qmail-create
PATCHES=`awk 'BEGIN{ for(i = 0; i <= 15; i++) print i}'`
TEMPLATE=$PNAME-template.spec
_PATCHEXT=""
_STRING=""
OUTNAME=$PNAME$_PATCHEXT

TMP=/tmp/$PNAME-make-spec.sh.$$
trap "rm $TMP* 2>/dev/null" 0


do_one() {
    sed -e "s}^#PATCH$1#}}" $OUTNAME > $OUTNAME$1
    rm $OUTNAME
    OUTNAME=$OUTNAME$1
    _PATCHEXT=$_PATCHEXT$1
}

remove_one() {
    sed -e "/^#PATCH$1#/d" $OUTNAME > $OUTNAME.remove
    mv $OUTNAME.remove $OUTNAME
}

cp $TEMPLATE $OUTNAME

for i in $PATCHES; do
    echo $i >> $TMP.all
done

sort  -n $TMP.all | uniq | sed "s}^}_}" >  $TMP.all.ou
mv $TMP.all.ou $TMP.all


if [ "$1" = "all" ]; then
    
    for i in $(cat $TMP.all); do
	do_one $i
    done
    _STRING=patch

elif [ "$1" = "list" ]; then

    echo If I do not indicate the author of the patch,
    echo then it is from www.qmail.org.
    echo ""
    for i in $PATCHES;do
    grep "#PATCH_$i##" $TEMPLATE |sed "s}#PATCH_$i##}$i}"
    done
    exit 

elif [ "$1" = "" ]; then

    _STRING=memphis
    cp $TMP.all $TMP.diff

else

    for i in $@; do
	echo $i >> $TMP.list
    done
   
    sort -n $TMP.list | uniq | sed "s}^}_}" > $TMP.list.ou
    mv $TMP.list.ou $TMP.list

    for i in $(cat $TMP.list); do
	if ! grep -q '^'$i'$' $TMP.all; then
	    echo $i >> $TMP.bargs
	fi
	if [ -s $TMP.bargs  ]; then
	    echo $0: no patches $(cat $TMP.bargs | sed "s}_}}g")
	    exit 
	fi
    done 

    for i in $(cat $TMP.list); do
    	do_one $i
    done

    if [ "$(diff $TMP.list $TMP.all)" != "" ]; then
	diff $TMP.list $TMP.all | grep ">"|sed "s}> }}" \
	> $TMP.diff
    fi
    _STRING=patch		

fi


sed -e "s}_STRING}$_STRING}" \
    -e "s}_PATCHEXT}$_PATCHEXT}" \
    $OUTNAME > $OUTNAME.string
mv $OUTNAME.string $OUTNAME

if [ "$_STRING" = "memphis" ]; then
    sed -e '/#BPATCH/,/#EPATCH/ d' \
	-e '/#BNOPATCH/d' \
	-e '/#ENOPATCH/d' $OUTNAME > $OUTNAME.ifpatch
    mv $OUTNAME.ifpatch $OUTNAME
else
    sed -e '/#BNOPATCH/,/#ENOPATCH/ d' \
	-e '/#BPATCH/d' \
	-e '/#EPATCH/d' $OUTNAME > $OUTNAME.ifpatch
    mv $OUTNAME.ifpatch $OUTNAME
fi

if [ -f $TMP.diff ]; then
    for i in $(cat $TMP.diff); do
      remove_one $i
    done
    mv $OUTNAME $OUTNAME.spec
else
    mv $OUTNAME $OUTNAME.spec
fi

if [ "$?" = "0" ]; then
    echo written $OUTNAME.spec
else
    echo problems
fi

