#! /bin/sh

# mem_replace.sh [template...] 

# mem_replace.sh reads assignments from stdin, replaces strings in the
# file(s) `template' according to these assignments, and the result is
# given to stdout.  If template is not given then the strings to be
# replaced are expected from stdin.

# Each line of the input contains
# assignments of the form

#   string1=string2

# Each occurence of string1 will be replaced by string2 in `template'.
# The strings in an assignment will be fed to sed with separator `}',
# so they can contain `/', but beware of using regexps.  Both string1
# and string2 can contain whitespace.  The use of whitespace in
# string1 is dicouraged.  

# To have `}' in string?, you need to escape it as  `\}'.

# The point is that multiple string replacement in a file may result
# in unexpected results due to a string being a substring of another one.

# The following is a typical example for (probably) undesired substitution

#    echo POOH POO PO | sed -e 's}PO}po}g' -e 's}POO}poo}g' -e 's}POOH}pooh}g'

# mem_replace.sh just makes sure that the above substitutions 
# are executed in the right order:

#   echo POOH POO PO | sed -e 's}POOH}pooh}g' -e 's}POO}poo}g' -e 's}PO}po}g'

# Hence all mem_replace.sh does is sort the strings to be replaced
# (string1) by their length and then create a sed script that makes
# the substitutions in the right order.

ASS=assignments.$$
trap "rm $ASS* 2>/dev/null" 0
cat - > $ASS

# remove empty lines 
egrep -v "^ *$"  $ASS > $ASS.tmp
mv $ASS.tmp $ASS

if [ -n "`awk -F= 'NF < 2 { print }' $ASS`" ]; then
    echo "$0: syntax error in assignments"
    exit 1
fi

awk -F= '{ print length($1)" ="$0 }' $ASS | sort -nr |
    awk -F= '{ print "s}"$2"}"$3"}g" }' > $ASS.sed

if [ $# = 0 ]; then
    sed -f $ASS.sed < /dev/tty
else
   sed -f $ASS.sed "$@"
fi
