# Automatically edited; change at your own high risk
%define destdir %buildroot
Buildprereq: shadow-utils
Buildroot: VDESTDIR
Conflicts: sendmail exim smail
License: Check with djb@cr.yp.to
ExclusiveOS: Linux
Group: Utilities/System
Name: VNAME 
###Obsoletes: qmail
Packager: VPACKAGER
Provides: MTA smtpdaemon
### For now, commented 
# Provides: qmail
Release: VRELEASE
Requires: shadow-utils
Source: DISTDIR.tar.gz
Summary: qmail Mail Transfer Agent
URL: http://cr.yp.to/qmail.html
Version: VERSION

%description
qmail is a small, fast, secure replacement for the
sendmail package, which is the program that actually receives, routes,
and delivers electronic mail.  *** Note: Be sure and read the
documentation as there are some small but very significant differences
between sendmail and qmail and the programs that interact with them.

%prep
### remove argument to -n when VNAME can be changed to var-qmail
%setup -n DISTDIR


%install
rm -rf %destdir
make 

# these are needed/useful after installation
cp config config-fast dnsfq dnsip dnsptr hostname \
instcheck ipmeprint VQMAILHOME/bin

%clean
rm -rf %destdir

%pre
export PATH=/command:/usr/local/bin:$PATH
# Try to stop qmail daemons for those who do not 
# read READMEs
for i in "" -smtpd -pop3d -qmtpd -qmqpd; do
    if [ -f /etc/rc.d/init.d/qmail${i}.init ]; then
        /etc/rc.d/init.d/qmail${i}.init stop
    fi
    if [ -f /service/qmail${i} ]; then
        svc -d /service/qmail${i}
    fi    
done

if [ -f /etc/rc.d/init.d/rblsmtpd.init ]; then
    /etc/rc.d/init.d/rblsmtpd.init stop
fi
if [ -L /service/rblsmtpd ]; then
    svc -d /service/rblsmtpd
fi

%preun
export PATH=/command:/usr/local/bin:$PATH
# Try to stop qmail daemons for those who do not 
# read READMEs
for i in "" -smtpd -pop3d -qmtpd -qmqpd; do
    if [ -f /etc/rc.d/init.d/qmail${i}.init ]; then
        /etc/rc.d/init.d/qmail${i}.init stop
    fi
    if [ -L /service/qmail${i} ]; then
        svc -d /service/qmail${i}
    fi    
done

if [ -f /etc/rc.d/init.d/rblsmtpd.init ]; then
    /etc/rc.d/init.d/rblsmtpd.init stop
fi
if [ -L /service/rblsmtpd ]; then
    svc -d /service/rblsmtpd
fi

%post
# set up files in QMAILHOME/control only if we are not upgrading 
if [ $1 = "1" ]; then
    (
    cd QMAILHOME/bin
    ./config-fast $(hostname -f)
    )
fi

(
cd QMAILHOME/bin
./instcheck
)

%postun
# If qmail is removed (so not upgraded):
if [ $1 = 0 ]; then

    # this is needed for user* and group* programs
    export PATH=$PATH:/usr/sbin

    echo ""
    echo "Removing qmail users (if they exist):"

    function user_del() {
	if  id -u $1 >/dev/null 2> /dev/null ; then
	    echo "   Removing $1 user ..."
	    userdel $1
	fi
    }
    for i in alias qmaild qmaill qmailp qmailq qmailr qmails; do
	user_del $i
    done

    ## update nis database
    if /sbin/pidof ypserv >/dev/null 2>/dev/null; then
	(cd /var/yp; make)
    fi

    echo ""
    echo "Removing qmail groups (if they exist):"
    function group_del() {
	if groupmod $1  >/dev/null 2> /dev/null; then
	    echo "   Removing $1 group ..."
	    groupdel $1
	fi
    }
    for i in nofiles qmail; do
	group_del $i
    done

    ## update nis database
    if /sbin/pidof ypserv >/dev/null 2>/dev/null; then
	(cd /var/yp; make)
    fi

fi

%files
%config QMAILHOME/boot/*
%doc  doc/*
%dir QMAILHOME
%dir QMAILHOME/alias
%dir QMAILHOME/boot
%dir QMAILHOME/control
%dir QMAILHOME/users
QMAILHOME/bin
QMAILHOME/doc
QMAILHOME/man
QMAILHOME/queue
QMAILHOME/rc

%changelog
* Thu May  2 2002 Mate Wierdl <mw@csi.hu>
- updated for daemontools stop
 
* Wed Aug 11 1999 <mw@moni.msci.memphis.edu>
--  put in %pre and %preun to try to stop the daemons.


