#!/bin/sh

# Makes spec files for each supported db.

# ezmlm-EZINTEGER.EZDECIMAL:
EZINTEGER=0
EZDECIMAL=53

# ezmlm-idx-IDXINTEGER.IDXDECIMAL
# If IDXDECIMAL is only two digits, we add a 0.
IDXINTEGER=0
IDXDECIMAL=421

# rpm release number
RELEASE=112memphis

# List of db's supported.  The name of a db has to be the same
# as the argument to make when building.
DBLIST="std mysql pgsql"

# Location of ezmlmrc.  For Linux, RCDIR is used, on other OS,
# OTHER_RCDIR is used.
RCDIR=/etc/ezmlm
OTHER_RCDIR=/usr/local/etc/ezmlm

# On Linux, the excutables will be  installed in $EZROOT/bin and the man 
# pages in  $EZROOT/man.  On non-Linux systems OTHER_EZROOT is used.
EZROOT=/usr
OTHER_EZROOT=/usr/local

# Where to install ezmlm-cgi.  For Linux, EZCGI is used, on other OS,
# OTHER_EZCGI is used.
EZCGI=/var/www/cgi-bin
OTHER_EZCGI=/usr/local/apache/cgi-bin

# If DO_CONFLICTS is set to "y", then the spec file will 
# say that the package conflicts with ezmlm, and all the other
# ezmlm-idx-* which support different db.
# The option --force to rpm can still be used to install the package.
DO_CONFLICTS="y"

# If DO_PATCH is set to "y", the patch named
# ezmlm-idx-0.53.400.unified_41.patch is applied with
# `patch -p1' after idx.patch is applied.
DO_PATCH="n"

# If DO_GCCTEST is set to "y", then optimizing will be turned off
# for gcc versions 2.95 or 2.95.1
DO_GCCTEST="y"

#===============End Customize

# Add extra 0's to the version if IDXDECIMAL is less than 3 digits
LENGTH="$(echo $IDXDECIMAL| awk '{ print length($1)}')"
case "$LENGTH" in
    "1")
	_EXTRA=00
	;;
    "2")
	_EXTRA=0
	;;
    "3")
	_EXTRA=""
	;;
    *)
    	echo "$0: Cannot handle IDXDECIMAL; exiting"
	exit 1
esac

if [ "$DO_CONFLICTS" = "y" ]; then

    for DB in $DBLIST; do
        CONFLICTS="Conflicts: ezmlm"
	for other in $DBLIST; do
	    if [ $other != $DB ]; then
		CONFLICTS="$CONFLICTS ezmlm-idx-$other"
	    fi
	done

	echo "
	CONFLICTS=$CONFLICTS
	DB=$DB
	_EXTRA=$_EXTRA
	EZCGI=$EZCGI
	EZDECIMAL=$EZDECIMAL
	EZINTEGER=$EZINTEGER
	EZROOT=$EZROOT
	IDXDECIMAL=$IDXDECIMAL
	IDXINTEGER=$IDXINTEGER
	OTHER_EZCGI=$OTHER_EZCGI
	OTHER_EZROOT=$OTHER_EZROOT
	OTHER_RCDIR=$OTHER_RCDIR
	RCDIR=$RCDIR
	RELEASE=$RELEASE
	" | ./subok.sh ezmlm-idx-template.spec \
	> ezmlm-idx-$DB.spec

	if [ "$DO_PATCH" != "y" ]; then
	    sed -e '/Patch:/d' \
		-e '/%patch/d' ezmlm-idx-$DB.spec \
	    > 	ezmlm-idx-$DB.spec.$$
	    mv ezmlm-idx-$DB.spec.$$ ezmlm-idx-$DB.spec
	fi

	if [ "$DO_GCCTEST" = "y" ]; then
	    sed -e '/### gccb/d' \
		-e '/### gcce/d' ezmlm-idx-$DB.spec \
	    > 	ezmlm-idx-$DB.spec.$$
	    mv ezmlm-idx-$DB.spec.$$ ezmlm-idx-$DB.spec
	else
	    sed -e '/### gccb/,/### gcce/d' ezmlm-idx-$DB.spec \
	    > 	ezmlm-idx-$DB.spec.$$
	    mv ezmlm-idx-$DB.spec.$$ ezmlm-idx-$DB.spec
	fi
	
    done
else
    for DB in $DBLIST; do
	CONFLICTS=""
	echo "
	CONFLICTS=$CONFLICTS
	DB=$DB
	_EXTRA=$_EXTRA
	EZCGI=$EZCGI
	EZDECIMAL=$EZDECIMAL
	EZINTEGER=$EZINTEGER
	EZROOT=$EZROOT
	IDXDECIMAL=$IDXDECIMAL
	IDXINTEGER=$IDXINTEGER
	OTHER_EZCGI=$OTHER_EZCGI
	OTHER_EZROOT=$OTHER_EZROOT
	OTHER_RCDIR=$OTHER_RCDIR
	RCDIR=$RCDIR
	RELEASE=$RELEASE
	" | ./subok.sh ezmlm-idx.spec.template \
	> ezmlm-idx-$DB.spec

	if [ "$DO_PATCH" != "y" ]; then
	    sed -e '/Patch:/d' \
		-e '/%patch/d' ezmlm-idx-$DB.spec \
	    > 	ezmlm-idx-$DB.spec.$$
	    mv ezmlm-idx-$DB.spec.$$ ezmlm-idx-$DB.spec
	fi

	if [ "$DO_GCCTEST" = "y" ]; then
	    sed -e '/### gccb/d' \
		-e '/### gcce/d' ezmlm-idx-$DB.spec \
	    > 	ezmlm-idx-$DB.spec.$$
	    mv ezmlm-idx-$DB.spec.$$ ezmlm-idx-$DB.spec
	else
	    sed -e '/### gccb/,/### gcce/d' ezmlm-idx-$DB.spec \
	    > 	ezmlm-idx-$DB.spec.$$
	    mv ezmlm-idx-$DB.spec.$$ ezmlm-idx-$DB.spec

	fi
    done    
fi
