#! /bin/sh
set -e

command_dir="$(eval echo $COMMAND_DIR)"
getuid () {
    if [ "$#" = "0" ]; then
	id | sed -e 's/^uid=//' -e 's/(.*//'	
    else
	id $1 | sed -e 's/^uid=//' -e 's/(.*//' 
    fi
}

getgid () {
    if [ "$#" = "0" ]; then
	id | sed -e 's/^.*gid=//' -e 's/(.*//'
    else
	id $1 | sed -e 's/^.*gid=//' -e 's/(.*//'
    fi
}

if echo $DESTDIR| egrep -q 'tmp|temp|^[^/]' ; then
    mkdir -p $DESTDIR
elif [ "$DESTDIR" = "/" ]; then
    echo "You have DESTDIR set to \"/\"."
    exit 1
elif [ "$DESTDIR" = "" ]; then
    if [ "$(getuid)" != "0" ]; then
	echo You must be root to install
	exit 1
    fi    
fi

destclean() {
    if echo $DESTDIR| egrep -q 'tmp|temp|^[^/]' ; then
        rm -rf $DESTDIR
    elif [ "$DESTDIR" = "/" ]; then
        echo "You have DESTDIR set to \"/\"."
        exit 1
    fi    
}

list_exec() {
    /bin/ls rlc-*.in | sed 's}\.in$}}'
}

base() {
    mkdir -p -mu=rwx,go=rx $DESTDIR/$command_dir $DESTDIR/command 
    chmod u=rwx,go=rx $(list_exec)
    
    cp -p $(list_exec)  $DESTDIR/$command_dir
    (
    cd $DESTDIR/command
    ln -s ../$command_dir/* .
    if test "$command_dir" = "/package/admin/runlevelconf-$VERSION/command$"; then
	cd $DESTDIR/package/admin
	ln -s runlevelconf-$VERSION runlevelconf
    fi
    )

    mkdir -p -mu=rwx,go=rx $DESTDIR/$RUNLEVELCONF 

    chmod u=rw,go=r rlc.functions
    cp -p rlc.functions $DESTDIR/$RUNLEVELCONF

}

case "$1" in
    base)
	base
	;;
    destclean)
	destclean
	;;
    *)
	echo "$(basename $0) base|destclean"
esac
