#! /bin/bash

if [ $# = 0 -o $# = 1 ]; then
    echo "Usage: myenvdir.sh dir prog"
    exit 2
fi

dir=$1
shift

[ -d $dir ] || { echo "$(basename $0): cannot find $dir"; exit 1; }

for i in $(/bin/ls $dir); do
    myenv=$i
    export $myenv="$(head -1 $dir/$i | sed -e 's/^ *//' -e 's/ *$//')"
done

$@

