#! /bin/sh
set -e

# envuidgid has to be in PATH, so if it is not in /command, adjust
# below
PATH=/command:$PATH; export PATH

command_dir="$(eval echo $COMMAND_DIR)"

getuid () {
    if [ "$#" = "0" ]; then
	id | sed -e 's/^uid=//' -e 's/(.*//'	
    else
	id $1 | sed -e 's/^uid=//' -e 's/(.*//' 
    fi
}

getgid () {
    if [ "$#" = "0" ]; then
	id | sed -e 's/^.*gid=//' -e 's/(.*//'
    else
	id $1 | sed -e 's/^.*gid=//' -e 's/(.*//'
    fi
}

if echo $DESTDIR| egrep -q 'tmp|temp|^[^/]' ; then
    mkdir -p $DESTDIR 
elif [ "$DESTDIR" = "/" ]; then
    echo "You have DESTDIR set to \"/\"."
    exit 1
elif [ "$DESTDIR" = "" ]; then
    if [ "$(getuid)" != "0" ]; then
	echo You must be root to install
	exit 1
    fi
fi

destclean() {
    if echo $DESTDIR| egrep -q 'tmp|temp|^[^/]' ; then
	rm -rf $DESTDIR
    elif [ "$DESTDIR" = "/" ]; then
	echo "You have DESTDIR set to \"/\"."
	exit 1
    fi    
}

base() {

    mkdir -p -mu=rwx,go=rx $DESTDIR/$command_dir  \
    $DESTDIR/command $DESTDIR/service
    chmod u=rwx,go=rx *-service.sh
    cp -p *-service.sh $DESTDIR/$command_dir
    (
    cd $DESTDIR/command
    ln -s ../$command_dir/* .
    if test "$command_dir" = "/package/admin/dt-run-$VERSION/command$"; then
	cd $DESTDIR/package/admin
	ln -s dt-run-$VERSION dt-run
    fi    
    )

    mkdir -p -mu=rwx,go=rx $DESTDIR/$SERVICEROOT $DESTDIR/$VARSERVICEROOT 
    

    for i in $DLOGCONFDIR $SVSCANCONF $DTRUNCONF; do
	# GNU mkdir has a bug:  -m2755 does not work
	mkdir -p -mu=rwx,go=rx $DESTDIR/$i 
	chmod g+s $DESTDIR/$i
    done

    chmod u=rw,go=r *.functions dt-config dt-list
    chmod u=rwx,go=rx *.init 
    cp -p *.functions *.init dt-config dt-list $DESTDIR/$DTRUNCONF

    chmod u=rwx,go=rx svscan.run
    cp -p svscan.run $DESTDIR/$SVSCANCONF/run

}

qmail() {

    # test if qmaill is added
    envuidgid qmaill /bin/true
 
    for i in qmail qsmtpd qqmtpd qqmqpd qpop3d rblsmtpd; do
    
	if [ $i != qmail -a $i != rblsmtpd ]; then
	    i=$(echo $i |sed 's}^q}qmail-}')
	fi

	SERVICE=$i

	if ! echo $SLOGMAIN|grep -q "^/"; then
	    slogmain="$VARSERVICEROOT/$SERVICE/log/$SLOGMAIN"
	else
	    slogmain=$(eval echo $SLOGMAIN)
	fi
	

	mkdir -p -mu=rwx,go=rx $DESTDIR/$VARSERVICEROOT/$i 
	chmod g+s $DESTDIR/$VARSERVICEROOT/$i
	chmod u=rwx,go=rx $i.run
	cp -p $i.run $DESTDIR/$VARSERVICEROOT/$i/run

	mkdir -p -m755 $DESTDIR/$VARSERVICEROOT/$i/log 
	chmod g+s $DESTDIR/$VARSERVICEROOT/$i/log
	chmod u=rwx,go=rx $i.log.run
	cp -p $i.log.run $DESTDIR/$VARSERVICEROOT/$i/log/run

	mkdir -p -mu=rwx,go=rx $DESTDIR/$slogmain 
	chmod g+s $DESTDIR/$slogmain

	if [ "$(getuid)" = "0" ]; then
	    chown  qmaill $DESTDIR/$slogmain
	    chgrp $(getgid qmaill) $DESTDIR/$slogmain
	fi

    done

    mkdir -p -mu=rwx,go=rx $DESTDIR/$(eval echo $DEFAULTDELIVERY) 
    chmod u=rw,go=r defaultdelivery/*
    cp -p defaultdelivery/* $DESTDIR/$(eval echo $DEFAULTDELIVERY)
}

other() {

    envuidgid dtlog /bin/true

    for i in fingerd wuftpd proftpd rlogind rshd rsync telnetd; do

	SERVICE=$i

	if ! echo $SLOGMAIN|grep -q "^/"; then
	    slogmain="$VARSERVICEROOT/$SERVICE/log/$SLOGMAIN"
	else
	    slogmain=$(eval echo $SLOGMAIN)
	fi

	mkdir -p -mu=rwx,go=rx $DESTDIR/$VARSERVICEROOT/$i 
	chmod g+s $DESTDIR/$VARSERVICEROOT/$i
	chmod u=rwx,go=rx $i.run
	cp -p $i.run $DESTDIR/$VARSERVICEROOT/$i/run

	mkdir -p -m755 $DESTDIR/$VARSERVICEROOT/$i/log 
	chmod g+s $DESTDIR/$VARSERVICEROOT/$i/log
	chmod u=rwx,go=rx $i.log.run
	cp -p $i.log.run $DESTDIR/$VARSERVICEROOT/$i/log/run

	mkdir -p -mu=rwx,go=rx $DESTDIR/$slogmain 
	chmod g+s $DESTDIR/$slogmain
	if [ "$(getuid)" = "0" ]; then
	   chown  dtlog $DESTDIR/$slogmain
	   chgrp $(getgid dtlog) $DESTDIR/$slogmain 
	fi
	

    done
    
}

case "$1" in
    base)
	base
	;;
    qmail)
	qmail
	;;
    other)
	other
	;;
    destclean)
    	destclean
	;;
    *)
	echo "$(basename $0) base|qmail|other"
esac





