#! /bin/sh
set -e

sed -e "s}CONFRUNLEVELCONF_BIN}$RUNLEVELCONF_BIN}" \
    -e "s}CONFRUNLEVELCONF}$RUNLEVELCONF}" \
    -e "s%CONFRUNLEVEL%$RUNLEVEL%" \
    -e "s}CONFSVSCANCONF}$SVSCANCONF}" \
    -e "s}CONFDTRUNCONF}$DTRUNCONF}" \
    -e "s}CONFPATH}/command:$PATH}" \
    -e "s}CONFUCSPI_TCP_BIN}$UCSPI_TCP_BIN}" \
    -e "s%CONFSERVICE%$SERVICE%" \
    -e "s}CONFMAX_STOP}$MAX_STOP}" \
    -e "s}CONFMAX_START}$MAX_START}" \
    -e "s}CONFVARSERVICEROOT}$VARSERVICEROOT}" \
    -e "s}CONFCDB}$CDB}" \
    dt-config.in > dt-config 

sed -e "s}CONFMYSHELL}$MYSHELL}" \
    -e "s}CONFRUNLEVELCONF_BIN}$RUNLEVELCONF_BIN}" \
    -e "s}CONFPATH}/command:$PATH}" \
    -e "s}CONFVARSERVICEROOT}$VARSERVICEROOT}" \
    -e "s}CONFDTRUNCONF}$DTRUNCONF}" \
    -e "s%CONFRUNLEVEL%$RUNLEVEL%" \
    -e "s}CONFDRUNLEVELS}$DRUNLEVELS}" \
    add-service.sh.in > add-service.sh 

sed -e "s}CONFMYSHELL}$MYSHELL}" \
    -e "s}CONFRUNLEVELCONF_BIN}$RUNLEVELCONF_BIN}" \
    -e "s}CONFPATH}/command:$PATH}" \
    -e "s}CONFVARSERVICEROOT}$VARSERVICEROOT}" \
    -e "s}CONFDTRUNCONF}$DTRUNCONF}" \
    -e "s%CONFRUNLEVEL%$RUNLEVEL%" \
    -e "s}CONFDRUNLEVELS}$DRUNLEVELS}" \
    remove-service.sh.in > remove-service.sh  
    
for i in *.init.in; do
    sed -e "s}CONFMYSHELL}$MYSHELL}" \
	-e "s}CONFDTRUNCONF}$DTRUNCONF}" $i \
	> $(basename $i .in) 
done

for i in *.functions.in; do
    sed -e "s}CONFMYSHELL}$MYSHELL}" $i \
    > $(basename $i .in) 
done
 
sed -e "s}CONFMYSHELL}$MYSHELL}" \
    svscan.run.in > svscan.run  

if [ "$UCSPI_TCP_BIN" = "/command" ]; then
    BOTH_PATH=/command
else
    BOTH_PATH=/command:$UCSPI_TCP_BIN 
fi

for i in fingerd wuftpd proftpd rlogind rshd rsync telnetd; do

    COMMAND="$(eval echo \$$i|cut -d:  -f1)"  
    PORT="$(eval echo \$$i|cut -d: -f2 )"  
    SERVICE="$i"
    if ! echo $SLOGMAIN|grep -q "^/"; then
	slogmain="./$SLOGMAIN"
    else
	slogmain=$SLOGMAIN
    fi
    
    sed -e "s}CONFMYSHELL}$MYSHELL}" \
	-e "s}CONFPORT}$PORT}" \
	-e "s}CONFCDB}$(eval echo $CDB)}" \
	-e "s}CONFCOMMAND}$COMMAND}" \
	-e "s}CONFUSER}root}" \
	-e "s}CONFPATH}$BOTH_PATH:$PATH}" \
	generic.run.in > $i.run  
    
    sed -e "s}CONFMYSHELL}$MYSHELL}" \
	-e "s}CONFDLOGCONFDIR}$(eval echo $DLOGCONFDIR)}" \
    	-e "s}CONFSLOGCONFDIR}$(eval echo $SLOGCONFDIR})" \
	-e "s}CONFLOGUSER}dtlog}" \
	-e "s}CONFSLOGMAIN}$(eval echo $slogmain)}" \
	-e "s}CONFPATH}/command:$PATH}" \
	generic.log.run.in > $i.log.run  
	
done


for i in qsmtpd qqmtpd qqmqpd rblsmtpd; do

    COMMAND="$(eval echo \$$i|cut -d:  -f1)"  
    PORT="$(eval echo \$$i|cut -d: -f2 )"  
    if [ $i != rblsmtpd ]; then
	SERVICE=$(echo $i |sed 's}^q}qmail-}')  
	i=$SERVICE
    else
	SERVICE="$i"
    fi
    
    sed -e "s}CONFMYSHELL}$MYSHELL}" \
	-e "s}CONFPORT}$PORT}" \
	-e "s}CONFCDB}$(eval echo $CDB)}" \
	-e "s}CONFCOMMAND}$(eval echo $COMMAND)}" \
	-e "s}CONFUSER}qmaild}" \
	-e "s}CONFPATH}$(eval echo $QMAIL_BIN):$BOTH_PATH:$PATH}" \
	generic.run.in > $i.run  

done

sed -e "s}CONFMYSHELL}$MYSHELL}" \
    -e "s}CONFDEFAULTDELIVERY}$(eval echo $DEFAULTDELIVERY)}" \
    -e "s}CONFQMAIL_BIN}$(eval echo $QMAIL_BIN)}" qmail.run.in > qmail.run

COMMAND="$(echo $qpop3d|cut -d:  -f1)"  
PORT="$(echo $qpop3d|cut -d: -f2 )" 
SERVICE="qmail-pop3d"

sed -e "s}CONFMYSHELL}$MYSHELL}" \
    -e "s}CONFPORT}$PORT}" \
    -e "s}CONFCDB}$(eval echo $CDB)}" \
    -e "s}CONFCOMMAND}$(eval echo $COMMAND)}" \
    -e "s}CONFPATH}$(eval echo $QMAIL_BIN):$BOTH_PATH:$PATH}" \
    -e "s}CONFcheckpassword}$checkpassword}" \
    -e "s}CONFQMAILHOME}$QMAILHOME}" \
    qmail-pop3d.run.in > qmail-pop3d.run 

for i in qmail qsmtpd qqmtpd qqmqpd qpop3d rblsmtpd; do

    if [ $i != rblsmtpd -a $i != qmail ]; then
	SERVICE=$(echo $i |sed 's}^q}qmail-}') 
	i=$SERVICE
    else
	SERVICE="$i"
    fi
    if ! echo $SLOGMAIN|grep -q "^/"; then
	slogmain="./$SLOGMAIN"
    else
	slogmain=$SLOGMAIN
    fi
    
    sed -e "s}CONFMYSHELL}$MYSHELL}" \
	-e "s}CONFDLOGCONFDIR}$(eval echo $DLOGCONFDIR)}" \
    	-e "s}CONFSLOGCONFDIR}$(eval echo $SLOGCONFDIR})" \
	-e "s}CONFLOGUSER}qmaill}" \
	-e "s}CONFSLOGMAIN}$(eval echo $slogmain)}" \
	-e "s}CONFPATH}/command:$PATH}" \
	generic.log.run.in > $i.log.run 
done
